% ------------------------------------------------------------------------
% Script: infile_2d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 2D P-N model
% ------------------------------------------------------------------------

    % System name
 
    system='2d P-N model';
 
    % The absolute path to save the result files
 
    filepath=pwd;
 
    % The dimension of P-N model: 1 or 2 

    misdim=2;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------ 
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
 
    % % the data of GSFE (unit: J/m2) and normalized disregistry vector (unit: 1)
    
    [Ux,Uz]=meshgrid(0:0.1:1,0:0.0666:1);
    SFE=[0	34.49336	81.69741	92.7249	61.34012	33.87816	80.9542	213.29039	336.62835	432.90695	460.53945	434.87288	327.81514	183.44135	51.97594	-0.62063;
35.23341	84.80735	135.59043	144.28467	106.37469	62.64697	84.54996	196.08193	332.85029	427.2584	453.45197	410.29965	307.52208	171.75433	60.37706	34.02698;
115.78546	197.42543	256.28348	259.77791	207.65134	129.56869	93.13519	149.04842	258.66648	347.02843	376.42647	339.67134	248.95489	141.46379	82.40535	116.64132;
201.6676	309.04244	373.58478	373.64947	309.38578	201.29577	103.79355	87.20437	154.75712	229.91033	261.25168	234.43975	163.73681	99.27182	110.3925	207.89426;
260.96896	383.01908	450.5949	449.01075	377.51755	251.05879	112.68231	34.43772	54.17393	112.92658	145.193	127.97595	79.39357	60.107	133.54081	273.42589;
280.6043	406.20991	474.39008	472.41284	399.54493	267.79815	115.13362	14.2487	10.89631	60.80318	92.87915	79.66182	41.69619	44.17238	141.73928	294.84214;
257.69573	376.95165	443.61236	442.02143	372.00109	247.67654	112.36159	35.712	55.57849	115.98269	147.32992	128.97113	78.84487	59.10368	131.54593	268.36721;
196.67995	300.27853	362.88887	363.64068	301.36554	196.70709	102.97525	89.05993	159.45166	238.42183	269.17557	238.59824	164.74329	97.75779	107.38253	202.12312;
113.44317	190.55688	247.22464	251.78889	201.19399	126.68765	92.30059	151.04013	265.578	357.17066	386.07789	347.02662	252.67053	141.47058	80.73299	113.198;
34.74441	83.22547	133.43179	141.19329	104.26445	62.28147	84.61917	197.31957	336.62835	432.90695	460.53945	416.20784	310.96811	172.54188	60.21693	33.66012;
0.59846	35.40621	82.69576	92.91534	61.93678	34.81498	81.1754	212.09436	357.17337	453.17241	480.92072	453.17241	328.65109	183.24367	52.63909	0.09771]'/1E3;
 
    % % Which trial function of disregistry vector to employ (>=-1)
    
    Nmis=0;     
     
    % % The value of Burgers vector (unit: A)
 
    BurVect=3.195;
 
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=20.7;
    poisson_ratio=0.264;
 
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='e';
    
    % % Which GSFE fitting function to employ (>=-1)
    
    fitcut=0;
    
    % % Mode of P-N models: CCPN (1) or SVPN (2)

    pnmode=2;
    
    % % Interplanar distance ?x (unit: A)
    
    Inpas=1/2*BurVect;
    
    % % The reference position x_m is defined as x_m=m?x+dax for SVPN model
    %   (m=0, 1, 2, , ?)
 
    dax=0.0;
 
   % % Matrix of the lower and upper bounds, and initial values of each unknown 
   %   variable ([Lower bound, Upper bound, StartPoint]) 
  
    Xcoef_range=[0.00, 1.00, 0.200];
    Xdist_range=[-50.00, 50.00, 8.00];
    Xwid_range=[0.00,20.00, 1.00];
    dx_range=[-5.00,5.00, 0.00];
    
    % % The minimization method for 2D P-N model: PSO ('2d_PSO') or GA ('2d_GA')
 
    minimethod='2d_PSO';   
    
    % % PSO or GA Parameters
 
        % % % Size of the population and maximum number of iteration
 
        PopulationSize=100;
        MaxIterations=1000;
       
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
    
    % % Interplanar distance ?x (unit: A) 

    % Inpas=BurVect;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
    
        % % % >>> For edge dislocation of FCC and HCP structures
 
        % LatC_spacing=sqrt(2/3)/2*BurVect;
        % [pressfld_latxz,pressfld_latyy]=meshgrid(-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect,...
        %                                -(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing);
 
        % % % >>> For screw dislocation of FCC structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+7/12)*BurVect:(1/2*BurVect):(6+11/12)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],10,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
        % % % >>> For screw dislocation of HCP structure
 
        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],15,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);
 
    % % Which component of the dislocation to calculate: x or z
    
    % dis_component_xz='x';
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of solid solution strengthening
% ------------------------------------------------------------------------
 
    % % Calculating the solid solution strengthening ('TRUE') or NOT ('FALSE')
    
    Solution_Strengthening='FALSE';
    
    % % Plotting the position-dependent solute/dislocation interaction energy
    %   ('TRUE') or NOT ('FALSE')
    
    % Einteraction_Plot='TRUE';
    
    % % The input volumetric misfit (eb_input) and slip misfit (es_input) parameters
    
    % eb_input=[];
    % es_input=[];
 
    % % The interlayer spacing along FCC [111] or HCP [0001] direction
 
    % LatC_spacing=[];

        % % % >>> for FCC structure

        % LatC_spacing=sqrt(2/3)/2*BurVect; 
 
    % % The coefficient to calculate the extra volume (unit: A^3), i.e. dV=coefV*eb
    
    % coefV=[];

        % % % >>> for FCC structure
    
        % coefV=3/4*(sqrt(2)*BurVect)^3;

    % % Matrix of the lower and upper bounds to search the characteristic bow-out distance wc (unit: A)
    
    % wc_range=[];        
        
    % % Concentration of solute atom
 
    % solute_concentration=1;
